//+------------------------------------------------------------------+
//|                                                               XO |
//|                                                           mladen | 
//+------------------------------------------------------------------+
#property link      "www.forex-station.com"
#property copyright "www.forex-station.com"

#property indicator_separate_window
#property indicator_buffers    4
#property indicator_color1     clrDeepSkyBlue
#property indicator_color2     clrPaleVioletRed
#property indicator_color3     clrGold
#property indicator_color4     clrGray
#property indicator_width1     2
#property indicator_width2     2
#property indicator_width3     3
#property indicator_width4     3
#property indicator_levelcolor clrMediumOrchid
#property indicator_levelstyle STYLE_DOT
#property strict

//
//
//
//
//

enum enPrices
{
   pr_close,      // Close
   pr_open,       // Open
   pr_high,       // High
   pr_low,        // Low
   pr_median,     // Median
   pr_typical,    // Typical
   pr_weighted,   // Weighted
   pr_average,    // Average (high+low+open+close)/4
   pr_medianb,    // Average median body (open+close)/2
   pr_tbiased,    // Trend biased price
   pr_tbiased2,   // Trend biased (extreme) price
   pr_haclose,    // Heiken ashi close
   pr_haopen ,    // Heiken ashi open
   pr_hahigh,     // Heiken ashi high
   pr_halow,      // Heiken ashi low
   pr_hamedian,   // Heiken ashi median
   pr_hatypical,  // Heiken ashi typical
   pr_haweighted, // Heiken ashi weighted
   pr_haaverage,  // Heiken ashi average
   pr_hamedianb,  // Heiken ashi median body
   pr_hatbiased,  // Heiken ashi trend biased price
   pr_hatbiased2, // Heiken ashi trend biased (extreme) price
   pr_habclose,   // Heiken ashi (better formula) close
   pr_habopen ,   // Heiken ashi (better formula) open
   pr_habhigh,    // Heiken ashi (better formula) high
   pr_hablow,     // Heiken ashi (better formula) low
   pr_habmedian,  // Heiken ashi (better formula) median
   pr_habtypical, // Heiken ashi (better formula) typical
   pr_habweighted,// Heiken ashi (better formula) weighted
   pr_habaverage, // Heiken ashi (better formula) average
   pr_habmedianb, // Heiken ashi (better formula) median body
   pr_habtbiased, // Heiken ashi (better formula) trend biased price
   pr_habtbiased2 // Heiken ashi (better formula) trend biased (extreme) price
};

extern ENUM_TIMEFRAMES TimeFrame                 = PERIOD_CURRENT;   // Time frame
extern string          ForSymbol                 = "";               // Symbol to use (leave empty for current symbol)
extern int             AtrPeriod1                = 14;                // First atr
extern int             AtrPeriod2                = 50;               // Second atr
extern enPrices        BoxPrice                  = pr_close;         // Price to use for box calculation
extern double          levelUp                   = 1;                // Upper level
extern double          levelDn                   = -1;               // Lower level
extern bool            arrowsVisible             = false;            // Show arrows?
extern string          arrowsIdentifier          = "Xo arrows1";     // Arrows ID
extern bool            arrowsOnNewest            = false;            // Arrows drawn on newest bar of higher time frame bar?
extern double          arrowsUpperGap            = 0.5;              // Arrows Upper Gap
extern double          arrowsLowerGap            = 0.5;              // Arrows lower gap
extern bool            arrowsOnPTrend            = false;            // Show arrows on primary trend?
extern color           arrowsOnPTrendUpColor     = clrLimeGreen;     // Primary trend Up arrow color
extern color           arrowsOnPTrendDnColor     = clrRed;           // Primary trend Down arrows color
extern int             arrowsOnPTrendUpCode      = 241;              // Primary trend Up arrow code
extern int             arrowsOnPTrendDnCode      = 242;              // Primary trend Down arrow code
extern int             arrowsOnPTrendUpSize      = 2;                // Primary trend Up arrow size
extern int             arrowsOnPTrendDnSize      = 2;                // Primary trend Down arrow size
extern bool            arrowsOnSTrend            = false;            // Show arrows on secondary trend?      
extern color           arrowsOnSTrendUpColor     = clrLimeGreen;     // Secondary trend Up arrow color
extern color           arrowsOnSTrendDnColor     = clrRed;           // Secondary trend Down arrows color
extern int             arrowsOnSTrendUpCode      = 159;              // Secondary trend Up arrow code
extern int             arrowsOnSTrendDnCode      = 159;              // Secondary trend Down arrow code
extern int             arrowsOnSTrendUpSize      = 2;                // Secondary trend Up arrow size
extern int             arrowsOnSTrendDnSize      = 2;                // Secondary trend Down arrow size  
extern bool            arrowsOnLevelCross        = false;            // Show arrows on upper/lower level cross?      
extern color           arrowsOnLevelCrossUpColor = clrLimeGreen;     // Upper/lower level cross Up arrow color
extern color           arrowsOnLevelCrossDnColor = clrRed;           // Upper/lower level cross Down arrows color
extern int             arrowsOnLevelCrossUpCode  = 108;              // Upper/lower level cross Up arrow code
extern int             arrowsOnLevelCrossDnCode  = 108;              // Upper/lower level cross Down arrow code
extern int             arrowsOnLevelCrossUpSize  = 2;                // Upper/lower level cross Up arrow size
extern int             arrowsOnLevelCrossDnSize  = 2;                // Upper/lower level cross Down arrow size  
extern bool            alertsOn                  = true;             // Alerts on?   
extern bool            alertsOnPTrend            = true;             // Alerts on primary trend change
extern bool            alertsOnSTrend            = true;             // Alerts on secondary trend change    
extern bool            alertsOnLevelCross        = true;             // Alerts on upper/lower level cross  
extern bool            alertsOnCurrent           = true;             // Alerts on current open bar?
extern bool            alertsMessage             = true;             // Alerts messagwe?
extern bool            alertsSound               = false;            // Alerts sound?
extern bool            alertsNotify              = true;             // Alerts send notification?
extern bool            alertsEmail               = true;             // Alerts send email?
extern string          soundFile                 = "alert2.wav";     // Alerts sound file

double no1[],kr1[],no2[],kr2[],trend1[],trend2[],trend3[],count[];
string indicatorFileName;
#define _mtfCall(_buff,_ind) iCustom(ForSymbol,TimeFrame,indicatorFileName,PERIOD_CURRENT,"",AtrPeriod1,AtrPeriod2,BoxPrice,levelUp,levelDn,arrowsVisible,arrowsIdentifier,arrowsOnNewest,arrowsUpperGap,arrowsLowerGap,arrowsOnPTrend,arrowsOnPTrendUpColor,arrowsOnPTrendDnColor,arrowsOnPTrendUpCode,arrowsOnPTrendDnCode,arrowsOnPTrendUpSize,arrowsOnPTrendDnSize,arrowsOnSTrend,arrowsOnSTrendUpColor,arrowsOnSTrendDnColor,arrowsOnSTrendUpCode,arrowsOnSTrendDnCode,arrowsOnSTrendUpSize,arrowsOnSTrendDnSize,arrowsOnLevelCross,arrowsOnLevelCrossUpColor,arrowsOnLevelCrossDnColor,arrowsOnLevelCrossUpCode,arrowsOnLevelCrossDnCode,arrowsOnLevelCrossUpSize,arrowsOnLevelCrossDnSize,alertsOn,alertsOnPTrend,alertsOnSTrend,alertsOnLevelCross,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,_buff,_ind)

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int init()
{
   IndicatorBuffers(8);   
      SetIndexBuffer(0,kr1,INDICATOR_DATA); SetIndexStyle(0,DRAW_HISTOGRAM);
      SetIndexBuffer(1,no1,INDICATOR_DATA); SetIndexStyle(1,DRAW_HISTOGRAM);
      SetIndexBuffer(2,kr2,INDICATOR_DATA); SetIndexStyle(2,DRAW_LINE);
      SetIndexBuffer(3,no2,INDICATOR_DATA); SetIndexStyle(3,DRAW_LINE);
      SetIndexBuffer(4,trend1);
      SetIndexBuffer(5,trend2);
      SetIndexBuffer(6,trend3);
      SetIndexBuffer(7,count);
      SetLevelValue(0,levelUp);
      SetLevelValue(1,0);
      SetLevelValue(2,levelDn);
      
      indicatorFileName = WindowExpertName();
      TimeFrame         = MathMax(TimeFrame,_Period);  
      ForSymbol         = (ForSymbol=="") ? _Symbol : ForSymbol; 
      
   IndicatorShortName(ForSymbol+" "+timeFrameToString(TimeFrame)+" XO ("+(string)AtrPeriod1+","+(string)AtrPeriod2+")");
return(0);
}
int deinit()
{
  string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double work[][4];
#define _hi1 0
#define _lo1 1
#define _hi2 2
#define _lo2 3

//
//
//
//
//

int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = fmin(Bars-counted_bars,Bars-1); count[0]=limit;
            if (TimeFrame!=_Period || ForSymbol!=_Symbol)
            {
               limit = (int)MathMax(limit,MathMin(Bars-1,_mtfCall(7,0)*TimeFrame/_Period));
               for (i=limit;i>=0 && !_StopFlag; i--)
               {
                  int y = iBarShift(ForSymbol,TimeFrame,Time[i]);
                     kr1[i]  = _mtfCall(0,y);
                     no1[i]  = _mtfCall(1,y);
                     kr2[i]  = _mtfCall(2,y);
                     no2[i]  = _mtfCall(3,y);
               }
      return(0);
      }  
      
      //
      //
      //
      //
      //
                   
      if (ArrayRange(work,0)!=Bars) ArrayResize(work,Bars);
      for(i=limit, r=Bars-i-1; i>=0; i--,r++)
      {       
         double cur = getPrice(BoxPrice,Open,Close,High,Low,i); 
         double BoxSize1 = iATR(NULL,0,AtrPeriod1,i);
         double BoxSize2 = iATR(NULL,0,AtrPeriod2,i);
           if (i>=(Bars-2))
           {
               work[r][_hi1]=cur; work[r][_hi2]=cur;
               work[r][_lo1]=cur; work[r][_lo2]=cur;
               continue; 
           }

           //
           //
           //
           //
           //
      
            work[r][_hi1] = work[r-1][_hi1];
            work[r][_lo1] = work[r-1][_lo1];
            work[r][_hi2] = work[r-1][_hi2];
            work[r][_lo2] = work[r-1][_lo2];
            no1[i]        = no1[i+1];
            kr1[i]        = kr1[i+1];
            no2[i]        = no2[i+1];
            kr2[i]        = kr2[i+1];
           
            if (cur > (work[r][_hi1]+BoxSize1)) { work[r][_hi1] = cur; work[r][_lo1] = cur-BoxSize1; kr1[i] += 1; no1[i] = 0; }
            if (cur < (work[r][_lo1]-BoxSize1)) { work[r][_lo1] = cur; work[r][_hi1] = cur+BoxSize1; no1[i] -= 1; kr1[i] = 0; }
            if (cur > (work[r][_hi2]+BoxSize2)) { work[r][_hi2] = cur; work[r][_lo2] = cur-BoxSize2; kr2[i] += 1; no2[i] = 0; }
            if (cur < (work[r][_lo2]-BoxSize2)) { work[r][_lo2] = cur; work[r][_hi2] = cur+BoxSize2; no2[i] -= 1; kr2[i] = 0; }
            trend1[i] = (i<Bars-1) ? (kr1[i]>0) ? 1 : (no1[i]<0) ? -1 : trend1[i+1] : 0;
            trend2[i] = (i<Bars-1) ? (kr2[i]>0) ? 1 : (no2[i]<0) ? -1 : trend2[i+1] : 0;
            trend3[i] = (kr2[i]>levelUp)  ? 1 : (no2[i]<levelDn) ? -1 : 0;
               
            if (arrowsVisible)
            {
                ObjectDelete(arrowsIdentifier+":1:"+(string)Time[i]);
                ObjectDelete(arrowsIdentifier+":2:"+(string)Time[i]);
                ObjectDelete(arrowsIdentifier+":3:"+(string)Time[i]);
                string lookFor = arrowsIdentifier+":"+(string)Time[i]; ObjectDelete(lookFor);
                if (i<(Bars-1) && arrowsOnPTrend && trend1[i] != trend1[i+1])
                {
                   if (trend1[i] == 1) drawArrow("1",0.5,i,arrowsOnPTrendUpColor,arrowsOnPTrendUpCode,arrowsOnPTrendUpSize,false);
                   if (trend1[i] ==-1) drawArrow("1",0.5,i,arrowsOnPTrendDnColor,arrowsOnPTrendDnCode,arrowsOnPTrendDnSize,true);
                 }
                 if (i<(Bars-1) && arrowsOnSTrend && trend2[i] != trend2[i+1])
                 {
                   if (trend2[i] == 1) drawArrow("2",1,i,  arrowsOnSTrendUpColor,arrowsOnSTrendUpCode,arrowsOnSTrendUpSize,false);
                   if (trend2[i] ==-1) drawArrow("2",1,i,  arrowsOnSTrendDnColor,arrowsOnSTrendDnCode,arrowsOnSTrendDnSize,true);
                 }
                 if (i<(Bars-1) && arrowsOnLevelCross && trend3[i] != trend3[i+1])
                 {
                   if (trend3[i] == 1) drawArrow("3",1.5,i,arrowsOnLevelCrossUpColor,arrowsOnLevelCrossUpCode,arrowsOnLevelCrossUpSize,false);
                   if (trend3[i] ==-1) drawArrow("3",1.5,i,arrowsOnLevelCrossDnColor,arrowsOnLevelCrossDnCode,arrowsOnLevelCrossDnSize,true);
                 }
             }
      }
      
      if (alertsOn)
      {
        int whichBar = 1; if (alertsOnCurrent) whichBar = 0; 
        static datetime time1 = 0;
        static string   mess1 = "";
        if (alertsOnPTrend && trend1[whichBar] != trend1[whichBar+1])
        {
           if (trend1[whichBar] == 1) doAlert(time1,mess1,whichBar,"primary changed to up");
           if (trend1[whichBar] ==-1) doAlert(time1,mess1,whichBar,"primary changed to down");
        }         
        static datetime time2 = 0;
        static string   mess2 = "";
        if (alertsOnSTrend && trend2[whichBar] != trend2[whichBar+1])
        {
           if (trend2[whichBar] ==  1) doAlert(time2,mess2,whichBar,"secondary changed to up");
           if (trend2[whichBar] == -1) doAlert(time2,mess2,whichBar,"secondary changed to down");
        }
        static datetime time3 = 0;
        static string   mess3 = "";
        if (alertsOnLevelCross && trend3[whichBar] != trend3[whichBar+1])
        {
           if (trend3[whichBar] ==  1) doAlert(time2,mess2,whichBar,"crossing upper level up");
           if (trend3[whichBar] == -1) doAlert(time2,mess2,whichBar,"crossing lower level down");
        }         
              
      
      }         
return(0);
}
   
//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//
//

#define priceInstances     1
#define priceInstancesSize 4
double workHa[][priceInstances*priceInstancesSize];
double getPrice(int tprice, const double& open[], const double& close[], const double& high[], const double& low[], int i, int instanceNo=0)
{
  if (tprice>=pr_haclose)
   {
      if (ArrayRange(workHa,0)!= Bars) ArrayResize(workHa,Bars); instanceNo*=priceInstancesSize; int r = Bars-i-1;
         
         //
         //
         //
         //
         //
         
         double haOpen  = (r>0) ? (workHa[r-1][instanceNo+2] + workHa[r-1][instanceNo+3])/2.0 : (open[i]+close[i])/2;;
         double haClose = (open[i]+high[i]+low[i]+close[i]) / 4.0;
         if (tprice>=pr_habclose)
               if (high[i]!=low[i])
                     haClose = (open[i]+close[i])/2.0+(((close[i]-open[i])/(high[i]-low[i]))*fabs((close[i]-open[i])/2.0));
               else  haClose = (open[i]+close[i])/2.0; 
         double haHigh  = fmax(high[i], fmax(haOpen,haClose));
         double haLow   = fmin(low[i] , fmin(haOpen,haClose));

         //
         //
         //
         //
         //
         
         if(haOpen<haClose) { workHa[r][instanceNo+0] = haLow;  workHa[r][instanceNo+1] = haHigh; } 
         else               { workHa[r][instanceNo+0] = haHigh; workHa[r][instanceNo+1] = haLow;  } 
                              workHa[r][instanceNo+2] = haOpen;
                              workHa[r][instanceNo+3] = haClose;
         //
         //
         //
         //
         //
         
         switch (tprice)
         {
            case pr_haclose:
            case pr_habclose:    return(haClose);
            case pr_haopen:   
            case pr_habopen:     return(haOpen);
            case pr_hahigh: 
            case pr_habhigh:     return(haHigh);
            case pr_halow:    
            case pr_hablow:      return(haLow);
            case pr_hamedian:
            case pr_habmedian:   return((haHigh+haLow)/2.0);
            case pr_hamedianb:
            case pr_habmedianb:  return((haOpen+haClose)/2.0);
            case pr_hatypical:
            case pr_habtypical:  return((haHigh+haLow+haClose)/3.0);
            case pr_haweighted:
            case pr_habweighted: return((haHigh+haLow+haClose+haClose)/4.0);
            case pr_haaverage:  
            case pr_habaverage:  return((haHigh+haLow+haClose+haOpen)/4.0);
            case pr_hatbiased:
            case pr_habtbiased:
               if (haClose>haOpen)
                     return((haHigh+haClose)/2.0);
               else  return((haLow+haClose)/2.0);        
            case pr_hatbiased2:
            case pr_habtbiased2:
               if (haClose>haOpen)  return(haHigh);
               if (haClose<haOpen)  return(haLow);
                                    return(haClose);        
         }
   }
   
   //
   //
   //
   //
   //
   
   switch (tprice)
   {
      case pr_close:     return(close[i]);
      case pr_open:      return(open[i]);
      case pr_high:      return(high[i]);
      case pr_low:       return(low[i]);
      case pr_median:    return((high[i]+low[i])/2.0);
      case pr_medianb:   return((open[i]+close[i])/2.0);
      case pr_typical:   return((high[i]+low[i]+close[i])/3.0);
      case pr_weighted:  return((high[i]+low[i]+close[i]+close[i])/4.0);
      case pr_average:   return((high[i]+low[i]+close[i]+open[i])/4.0);
      case pr_tbiased:   
               if (close[i]>open[i])
                     return((high[i]+close[i])/2.0);
               else  return((low[i]+close[i])/2.0);        
      case pr_tbiased2:   
               if (close[i]>open[i]) return(high[i]);
               if (close[i]<open[i]) return(low[i]);
                                     return(close[i]);        
   }
   return(0);
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

void doAlert(datetime& previousTime, string& previousAlert, int forBar, string doWhat)
{
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];
       
       //
       //
       //
       //
       //

       message = timeFrameToString(_Period)+" "+_Symbol+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" XO "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(message);
          if (alertsEmail)   SendMail(_Symbol+" XO ",message);
          if (alertsSound)   PlaySound(soundFile);
      }
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void drawArrow(string nameAdd, double gapMul, int i,color theColor, int theCode, int theWidth, bool up)
{
   string name = arrowsIdentifier+":"+nameAdd+":"+(string)Time[i];
   double gap  = iATR(NULL,0,20,i)*gapMul;   
   
      //
      //
      //
      //
      //
      
      int add = 0; if (!arrowsOnNewest) add = _Period*60-1;
      ObjectCreate(name,OBJ_ARROW,0,Time[i]+add,0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_WIDTH,theWidth);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}

